/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameMocGenImg;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class FrameMocGenProba
extends FrameMocGenImg {
    protected FrameMocGenProba(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCGENTITLE");
        this.INFO = Aladin.chaine.getString("MOCGENPROBAINFO");
        this.PLANE = Aladin.chaine.getString("MOCFILTERINGPROBA");
    }

    @Override
    protected boolean isPlanOk(Plan p) {
        return p.type == 16;
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        this.addSpecifPanel(p, c, g);
        JPanel pp = new JPanel();
        pp.add(new JLabel("MOC resolution :"));
        this.mocOrder = this.getComboRes();
        pp.add(this.mocOrder);
        p.add(pp);
        return p;
    }

    @Override
    protected void addSpecifPanel(JPanel p, GridBagConstraints c, GridBagLayout g) {
        JPanel pp = new JPanel();
        pp.add(new JLabel("Probability threshold : "));
        this.threshold = new JTextField(5);
        pp.add(this.threshold);
        c.gridwidth = 0;
        g.setConstraints(pp, c);
        p.add(pp);
    }

    private double getThreshold() throws Exception {
        double x = Double.NaN;
        try {
            String s = this.threshold.getText().trim();
            if (s.length() > 0) {
                x = Double.parseDouble(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return x;
    }

    @Override
    protected void submit() {
        try {
            Plan[] ps = new Plan[]{this.getPlan(this.ch[0])};
            int order = this.getOrder();
            if (order > 12) {
                if (!Aladin.confirmation("Do you really want to generate a so high MOC resolution ?")) {
                    return;
                }
            }
            double threshold = this.getThreshold();
            this.a.console.printCommand("cmoc -order=" + order + " -threshold=" + threshold + " " + FrameMocGenProba.labelList(ps));
            this.a.calque.newPlanMoc("MOC " + threshold + " " + ps[0].label, ps, order, 0.0, Double.NaN, Double.NaN, threshold, false);
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("MOC generation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
        try {
            Plan[] ps = new Plan[]{this.getPlan(this.ch[0])};
            int order = ((PlanBG)ps[0]).getMaxHealpixOrder();
            if (this.getOrder() > order) {
                this.mocOrder.setSelectedIndex(order - 3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

